//
//  URLLoader.m
//  Mensa
//
//  Created by Jonathan Diehl on 20.12.10.
//  Copyright 2010 RWTH. All rights reserved.
//

#import "URLLoader.h"


@interface URLLoader ()
- (void)cleanupConnection;
- (void)deliverData:(NSData *)someData error:(NSError *)error;
@end


@implementation URLLoader

+ (id)loadRequest:(NSURLRequest *)aRequest handler:(URLLoaderHandler)aHandler;
{
	URLLoader *request = [[[self alloc] initWithRequest:aRequest handler:aHandler] autorelease];
	[request start];
	return request;
}

+ (id)loadURL:(NSURL *)url handler:(URLLoaderHandler)aHandler;
{
	URLLoader *request =  [[[self alloc] initWithURL:url handler:aHandler] autorelease];
	[request start];
	return request;
}

// designated init
- (id)initWithRequest:(NSURLRequest *)aRequest handler:(URLLoaderHandler)aHandler;
{
	self = [super init];
	if (self != nil) {
		
		// retain ourselves
		[self retain];

		request = [aRequest retain];
		handler = [aHandler copy];
	}
	return self;
}

// init with url -> creates request
- (id)initWithURL:(NSURL *)url handler:(URLLoaderHandler)aHandler;
{
	return [self initWithURL:url handler:aHandler];
}

// cleanup
- (void)dealloc
{
	// we cannot call cancel here beause it would over-release us
	[connection cancel];
	[self cleanupConnection];
	
	// release everything else
	[request release];
	[handler release];

	[super dealloc];
}


#pragma mark control methods

// start the connection
- (void)start;
{
	if(connection) return;
	
	// load data from url
	data = [[NSMutableData alloc] init];
	connection = [[NSURLConnection alloc] initWithRequest:request delegate:self];
	[connection start];
}

// cancel the connection
- (void)cancel;
{
	[connection cancel];
	[self cleanupConnection];
	[self autorelease];
}


#pragma mark NSURLConnection delegate

// received data
- (void)connection:(NSURLConnection *)connection didReceiveData:(NSData *)someData
{
	[data appendData:someData];
}

// finished
- (void)connectionDidFinishLoading:(NSURLConnection *)connection
{
	NSData *finalData = [[data copy] autorelease];
	
	// deliver data
	[self deliverData:[[data copy] autorelease] error:nil];
}

// failed
- (void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error
{
	[self deliverData:nil error:error];
}


#pragma mark private methods

- (void)cleanupConnection;
{
	[connection release];
	connection = nil;
	
	[data release];
	data = nil;
}

- (void)deliverData:(NSData *)someData error:(NSError *)error;
{
	handler(someData, error);
	[self cleanupConnection];
}

@end
